package com.ElyStudio.leGaou.activities;

import androidx.annotation.NonNull;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.databinding.ActivityLoseBinding;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.Constants;

public class LoseActivity extends AppCompat {

    ActivityLoseBinding binding;
    private InterstitialAd mInterstitialAd;
    public static final String TAG = "LOSE_ACTIVITY";
    int adEnabled;
    String nativeAdId,interstitialAdId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityLoseBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.goToHomeBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showInterstitialAd();
            }
        });

    }

    @Override
    protected void onStart() {
        super.onStart();
        getAdData();
        loadNativeAd(binding.adPlaceHolder);
        loadInterstitialAd();
    }

    private void getAdData(){
        adEnabled = getIntent().getIntExtra(Constants.adEnabled,0);
        nativeAdId = getIntent().getStringExtra(Constants.nativeAdId);
        interstitialAdId = getIntent().getStringExtra(Constants.interstitialAdId);
    }

    private void loadInterstitialAd(){

        if(interstitialAdId == null)
        {
            interstitialAdId = getIntent().getStringExtra(Constants.interstitialAdId);
            getAdData();
        }

        if(adEnabled == 1)
        {
            AdRequest adRequest = new AdRequest.Builder().build();

            InterstitialAd.load(LoseActivity.this, interstitialAdId, adRequest, new InterstitialAdLoadCallback() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d(TAG,"Failed to load interstitial ad  = "+loadAdError);
                    mInterstitialAd = null;
                }

                @Override
                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded(interstitialAd);
                    mInterstitialAd = interstitialAd;
                }
            });
        }


    }

    public void showInterstitialAd(){

        binding.progressBar.setVisibility(View.VISIBLE);
        binding.goToHomeBtn.setVisibility(View.GONE);

        if(mInterstitialAd != null)
        {
            mInterstitialAd.show(LoseActivity.this);

            mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                @Override
                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    mInterstitialAd = null;
                    startActivity(new Intent(LoseActivity.this, MainActivity.class));
                    finish();
                }
            });
        }
        else
        {
            startActivity(new Intent(LoseActivity.this, MainActivity.class));
            finish();
        }

    }

    public void loadNativeAd(FrameLayout adPlaceHolder){

        if(nativeAdId == null)
        {
            getAdData();
        }

        if(adEnabled == 1)
        {

            AdLoader.Builder builder = new AdLoader.Builder(LoseActivity.this, nativeAdId);

            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener() {
                @Override
                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {

                    NativeAdView nativeAdView = (NativeAdView) getLayoutInflater().inflate(R.layout.medium_native_ad_layout, null);

                    populateNativeAd(nativeAdView, nativeAd);
                    adPlaceHolder.removeAllViews();
                    adPlaceHolder.addView(nativeAdView);

                }
            });

            AdLoader adLoader = builder.withAdListener(new AdListener() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d(TAG, "Failed to load native ad = " + loadAdError);
                }
            }).build();

            adLoader.loadAd(new AdRequest.Builder().build());
        }

    }

    public void populateNativeAd(NativeAdView nativeAdView, NativeAd nativeAd){

        nativeAdView.setHeadlineView(nativeAdView.findViewById(R.id.adHeadlineMedium));
        nativeAdView.setBodyView(nativeAdView.findViewById(R.id.adBodyMedium));
        nativeAdView.setIconView(nativeAdView.findViewById(R.id.adIconMedium));
        nativeAdView.setAdvertiserView(nativeAdView.findViewById(R.id.adAdvertiserMedium));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(R.id.callToActionButtonMedium));

        ((TextView) nativeAdView.getHeadlineView()).setText(nativeAd.getHeadline());

        if(nativeAd.getIcon() == null)
        {
            nativeAdView.getIconView().setVisibility(View.INVISIBLE);
        }
        else
        {
            nativeAdView.getIconView().setVisibility(View.VISIBLE);
            ((ImageView) nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
        }

        if(nativeAd.getBody() == null)
        {
            nativeAdView.getBodyView().setVisibility(View.INVISIBLE);
        }
        else
        {
            nativeAdView.getBodyView().setVisibility(View.VISIBLE);
            ((TextView) nativeAdView.getBodyView()).setText(nativeAd.getBody());
        }

        if(nativeAd.getAdvertiser() == null)
        {
            nativeAdView.getAdvertiserView().setVisibility(View.INVISIBLE);
        }
        else
        {
            nativeAdView.getAdvertiserView().setVisibility(View.VISIBLE);
            ((TextView) nativeAdView.getAdvertiserView()).setText(nativeAd.getAdvertiser());
        }

        if(nativeAd.getCallToAction() == null)
        {
            nativeAdView.getCallToActionView().setVisibility(View.INVISIBLE);
        }
        else
        {
            nativeAdView.getCallToActionView().setVisibility(View.VISIBLE);
            ((Button) nativeAdView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        nativeAdView.setNativeAd(nativeAd);

    }
}